# 컴퓨터의 구성
컴퓨터는 기본적으로 읽고, 처리한 뒤, 저장하는 과정으로 이루어져있으며, 그 과정에셔 **5가지의 구성요소**가 존재한다.

## 컴퓨터 하드웨어 구성

![image](https://user-images.githubusercontent.com/50827930/207626128-d57f9a2f-6590-473e-b2c7-c041dcc52df3.png)

1. 입력장치 : 컴퓨터의 내부에 데이터를 읽어들인다. (ex. 키보드, 마우스, 마이크 등)
2. 출력장치 : 데이터를 가공 처리하여 생성된 정보를 표시한다. (ex. 모니터, 프린터, 스피커 등)
3. 제어장치 : 컴퓨터의 5대 구성요소 장치들의 동작과 주고 받는 데이터의 흐름을 제어한다.
4. 연산장치 : CPU의 기능을 보충하기 위한 보조프로세서이다. (데이터 처리를 위한 산순연산과 논리연산 등을 담당)
5. 기억장치 : 프로그램이 처리한 정보들을 저장한다. (ex. ROM, RAM, HDD, SSD 등)

<br/>

다른 관점에서 구성 요소를 중앙처리장치(CPU)와 주기억장치, 보조기억장치로 나누어 볼 수도 있다.

![image](https://user-images.githubusercontent.com/50827930/207627672-729c031f-fb2e-41e3-972a-bd3cdd22c45b.png)

### 중앙처리장치(CPU)
- 컴퓨터 부품과 정보를 교환하면서 컴퓨터 시스템 전체를 제어하는 장치로, 모든 컴퓨터의 작동과정이 중앙 처리 장치(CPU)의 제어를 받기 때문에 컴퓨터의 두뇌에 해당한다고 할 수 있다.
- 데이터를 연산하거나 제어하거나 하는 산술논리연산장치(ALU)와 제어장치를 포함한다.
  - 산술연산장치(ALU) : 사칙연산, 논리연산, 데이터상태(Flag)표시, 시프트연산, 보수연산 등을 수행한다.
  - 제어장치 : CPU 내부에서 일어나는 작업들 통제관리, 명령어를 해독하고 해당 장치에 제어 신호 전달한다.
  - 레지스터 : CPU 내에서 데이터 저장하고 CPU로부터 읽어온 명령어와 데이터, 산술연산장치(ALU) 처리 결과를 임시 보관한다.

### 주기억장치
- 내부 기억장치에 속한다.
- 컴퓨터 시스템에서 수행되는 프로그램과 수행에 필요한 데이터를 기억한다.
- 중앙처리장치(CPU)에 접근하는 속도가 빠르다.
- ex. ROM(비휘발성, BIOS가 여기 설치되어 있음), RAM(휘발성)

### 보조기억장치
- 외부 기억장치에 속한다.
- 반영구적으로 데이터를 저장하고 보존한다.(비휘발성)
- 중앙처리장치(CPU)와 직접 정보 교환이 불가능해 주기억장치로 옮겨진 후에 처리됨.
- 가격이 저렴하고 저장 용량이 크지만, 속도가 느리기 때문에 중앙처리장치(CPU)와 직접적인 정보 교환이 불가능.
- ex. HDD, SSD

<br/>

## Bus

**Bus**는 컴퓨터 구성 장치들 간의 통신 시스템이다. 컴퓨터 안의 부품들 간에, 또는 컴퓨터 간에 데이터와 주소, 제어 신호 등 정보를 전송하는 통로이다.

하드웨어 구성 요소를 물리적으로 연결하며, 용도에 따라 데이터 버스, 주소버스, 제어버스로 나뉜다.
  - 데이터 버스 : 중앙처리장치(CPU)와 기타 장치 사이에서 데이터를 전달하는 통로(양방향)
  - 주소 버스 : CPU가 주기억장치나 입출력장치로 기억장치 주소를 전달하는 통로(단방향)
  - 제어 버스 : CPU가 기억장치나 입출력장치에 제어 신호를 전달하는 통로 (양방향 - 읽기 쓰기 모두 수행)

<br/>

## Reference
📄https://gyoogle.dev/blog/computer-science/computer-architecture/컴퓨터의%20구성.html    
📄https://salguworld.tistory.com/74  
📄https://lemonpoo22.tistory.com/m/79  
📄https://jamielim.tistory.com/entry/1주차-정리-컴퓨터-구성요소-하드웨어  
📄https://velog.io/@phc09188/컴퓨터구조-컴퓨터의-구조  
📄https://velog.io/@coreminw/컴퓨터구조-컴퓨터의-구성  
